define(['NotificationDeliveryDirective'], function() {
	'use strict';

	describe("The Notification Delivery Options directive", function (){
		var scope,
			notificationPreferencesService,
			compile,
			httpMock,
			formatterMock,
			q,
			isolateScope;

		beforeEach(function () {
			module('angularTemplateApp');

			formatterMock = jasmine.createSpyObj('formatter', ['getFormattedFrontendDate']);
			notificationPreferencesService = jasmine.createSpyObj('NotificationsPreferencesService', ['getPreferencesData']);
			notificationPreferencesService.getPreferencesData.and.returnValue({then: function() { return {finally: function() { return {} } } } });

			module(function($provide){
				$provide.value('NotificationsPreferencesService', notificationPreferencesService);
				$provide.value('formatter', formatterMock);
			});

			inject(function($compile, $rootScope, $templateCache, $httpBackend, $q) {
				scope = $rootScope;
				compile = $compile;
				httpMock = $httpBackend;
				q = $q;
				$templateCache.put('src/modules/health-mood/pages/notification-status/notification-delivery-options/notification-delivery-options_template.html', '<div></div>');
			});

			scope.details = {
				reminder: {
					enabledFlag: false,
					notificationTypes: ["In-App", "Email"]
				}
			};
		});

		describe("the link function", function () {
			it ("should initialize variables for recurring notifications", function() {
				var element = angular.element('<div notification-delivery-options ng-model="details.reminder" is-recurring="true"></div>');
				compile(element)(scope);
				scope.$apply();

				isolateScope = element.isolateScope();
				expect(isolateScope.emailAddress).toBeNull();
				expect(isolateScope.isEmailAddressStored).toBeNull();
				expect(isolateScope.reminderTypes).toEqual([{type:"In-App"},{type:"Email"}]);
				expect(isolateScope.notificationOptions).toEqual(["On", "Off"]);
				expect(isolateScope.notificationDates).toEqual(['Daily', 'Weekly', 'Monthly']);
				expect(isolateScope.errorHandling).toEqual({
					'deliverySelected': {
						message: 'A Notification Delivery method is needed to save this record. Please select a method and save again.',
						priority: 1
					}
				});
			});

			it ("should initialize variables for non-recurring notifications", function() {
				var element = angular.element('<div notification-delivery-options ng-model="details.reminder"></div>');
				compile(element)(scope);
				scope.$apply();

				isolateScope = element.isolateScope();
				expect(isolateScope.emailAddress).toBeNull();
				expect(isolateScope.isEmailAddressStored).toBeNull();
				expect(isolateScope.reminderTypes).toEqual([{type:"In-App"},{type:"Email"}]);
				expect(isolateScope.notificationOptions).toEqual(["On", "Off"]);
				expect(isolateScope.errorHandling).toEqual({
					'deliverySelected': {
						message: 'A Notification Delivery method is needed to save this record. Please select a method and save again.',
						priority: 1
					}
				});
			});

			describe("when calling to get email address is successful", function () {
				beforeEach(function () {
					var element = angular.element('<div notification-delivery-options ng-model="details.reminder"></div>'),
						deferred = q.defer();
					deferred.resolve({emailAddress: "email"});
					notificationPreferencesService.getPreferencesData.and.returnValue(deferred.promise);

					compile(element)(scope);
					scope.$apply();

					isolateScope = element.isolateScope();
				});

				it ("should call to get the user's email address", function () {
					expect(notificationPreferencesService.getPreferencesData).toHaveBeenCalled();
					expect(isolateScope.emailAddress).toEqual('email');
					expect(isolateScope.isEmailAddressStored).toBe(true);
				});
			});

			describe("when calling to get email address is unsuccessful", function () {
				beforeEach(function () {
					var element = angular.element('<div notification-delivery-options ng-model="details.reminder"></div>'),
						deferred = q.defer();
					deferred.reject();
					notificationPreferencesService.getPreferencesData.and.returnValue(deferred.promise);

					compile(element)(scope);
					scope.$apply();

					isolateScope = element.isolateScope();
				});

				it ("should call to get the user's email address", function () {
					expect(notificationPreferencesService.getPreferencesData).toHaveBeenCalled();
					expect(isolateScope.emailAddress).toBeNull();
					expect(isolateScope.isEmailAddressStored).toBe(false);
				});
			});
		});
	});
});